# ***** BEGIN LICENSE BLOCK *****
# Version: MPL 1.1/GPL 2.0/LGPL 2.1
#
# The contents of this file are subject to the Mozilla Public License Version
# 1.1 (the "License"); you may not use this file except in compliance with
# the License. You may obtain a copy of the License at
# http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# for the specific language governing rights and limitations under the
# License.
#
# The Original Code is Spicebird code.
#
# The Initial Developer of the Original Code is
#   Prasad Sunkari <prasad@synovel.com>
# Portions created by the Initial Developer are Copyright (C) 2007-2008
# the Initial Developer. All Rights Reserved.
#
# Contributor(s):
#   Sivakrishna Edpuganti <sivakrishna@synovel.com> 
#
#
# Alternatively, the contents of this file may be used under the terms of
# either of the GNU General Public License Version 2 or later (the "GPL"),
# or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
# in which case the provisions of the GPL or the LGPL are applicable instead
# of those above. If you wish to allow use of your version of this file only
# under the terms of either the GPL or the LGPL, and not to allow others to
# use your version of this file under the terms of the MPL, indicate your
# decision by deleting the provisions above and replace them with the notice
# and other provisions required by the GPL or the LGPL. If you do not delete
# the provisions above, a recipient may use your version of this file under
# the terms of any one of the MPL, the GPL or the LGPL.
#
# ***** END LICENSE BLOCK ***** 

const EVENT_DETECTOR_CID = "@synovel.com/collab/calendar/event-filter;1";
var gEventFilter = null;
var gFilterEvents;

const USEC_PER_SEC = 1000 * 1000;
var mainWindow = Components.classes["@mozilla.org/appshell/window-mediator;1"].getService()
                 .QueryInterface(Components.interfaces.nsIWindowMediator)
                 .getMostRecentWindow("collab:main");


if (mainWindow)
  window.addEventListener("load", initEventFilter, true);

var EventDetectionObserver = {
  observe: function (aHeaderSink, aTopic, aUri)
  {
    // This observer is invoked across windows and when message window is
    // open, loading a new message in message window or the main window 
    // invokes this observer in the other window as well.
    if(GetLoadedMessage() != aUri)
      return;
    var bar = document.getElementById("eventsFilterBar");
    bar.setAttribute("collapsed", "true");

    if(ignoreEventsSet() == true)
      return;

    if(aTopic == "MsgMsgDisplayed" && gEventFilter ) {
      gEventFilter.contextDate = gDBView.hdrForFirstSelectedMessage.dateInSeconds * USEC_PER_SEC;

      // remove all quoted text from the html 
      var bodyText = getFilterText(getMessageBrowser().contentDocument.body);
      var msgText = gDBView.hdrForFirstSelectedMessage.subject + ". " + bodyText

      gFilterEvents = gEventFilter.extractEvents(msgText, aUri, {});
      if(!gFilterEvents || gFilterEvents.length <= 0) 
        return;

      var nTitledEvents = 0;
      for (var i=0; i < gFilterEvents.length; i++)
        if (gFilterEvents[i].getProperty("X-TITLE-MATCH"))
          nTitledEvents++;

      if (!nTitledEvents)
        return;

      var text = document.getElementById("eventsFilterDescText");
      var hbox = document.getElementById("eventsFilterListHBox");
      var bundle = document.getElementById("bundle_eventfilter");
      while(hbox.childNodes.length > 0) 
        hbox.removeChild(hbox.childNodes[0]);

      if(nTitledEvents == 1) {
        text.setAttribute("value", bundle.getString("singleEventLabel"));
      } else {
        text.setAttribute("value", bundle.getString("multipleEventsLabel"));
      }

      for(var i=0; i < gFilterEvents.length; i++) {
        // Don't consider the events that dont have an event name for the
        // purpose of adding them in the events header
        if (!gFilterEvents[i].getProperty("X-TITLE-MATCH"))
          continue;
        // Set the calendar as the selected calendar.
        gFilterEvents[i].calendar = mainWindow.getSelectedCalendar();

        var label = document.createElementNS("http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul","label");
        label.setAttribute("value", getEventString (gFilterEvents[i]));
        label.setAttribute("class", "text-link");
        label.setAttribute("onclick", "addDetectedEvent(gFilterEvents[" + i + "])");
        hbox.appendChild(label);
      }
        
      bar.removeAttribute("collapsed");
    }
  }
};

function getFilterText(aNode) {
   if (!aNode)
     return '';

   var text = "";
   // Get rid of style data and blockquote tags with type='cite' attribute
   tagName = aNode.tagName;
   if (tagName)
      if (  tagName.toUpperCase() == "STYLE" ||
           (tagName.toUpperCase() == "BLOCKQUOTE" 
            && ("" + aNode.getAttribute("TYPE")).toUpperCase() == "CITE"))
               return "";
   for each (var node in aNode.childNodes) 
      text += getFilterText(node);
   if (aNode.nodeName == "#text") 
      text += aNode.textContent;

   return text;
}

function getEventString (aEvent)
{
  // XXX: localize the way strings are concatenated
  var eventString = "";
  var titleMatch = aEvent.getProperty("X-TITLE-MATCH");
  if (titleMatch)
    eventString = titleMatch + ": ";

  var dateMatchedText = aEvent.getProperty ("X-DATE-MATCH");
  var timeMatchedText = aEvent.getProperty ("X-TIME-MATCH");

  /* The only situation when this will needed is when date is not given
     if this assumption is wrong, uncomment this.
  if (!dateMatchedText && (timeMatchedText || aEvent.startDate.isDate)) {
    var dateTime = new Date (aEvent.startDate.year, aEvent.startDate.month,
                             aEvent.startDate.day);
    dateMatchedText = dateTime.toLocaleDateString ();
  }
  */

  /* The only situation when this will needed is when time is not given
     if this assumption is wrong, uncomment this.
  if (!aEvent.startDate.isDate && !timeMatchedText && dateMatchedText) {
    var dateTime = new Date (aEvent.startDate.year, aEvent.startDate.month,
                             aEvent.startDate.day, aEvent.startDate.hour,
                             aEvent.startDate.minute, aEvent.startDate.second);
    timeMatchedText = dateTime.toLocaleTimeString ();
  }
  */

  if (dateMatchedText) {
    eventString += dateMatchedText;

    if (timeMatchedText) {
      eventString += ", ";
    }
  }

  if (timeMatchedText)
    eventString += timeMatchedText;
  
  /* We will never have this situation
  if (!dateMatchedText && !timeMatchedText) {
    var dateTime = new Date (aEvent.startDate.year, aEvent.startDate.month,
                             aEvent.startDate.day, aEvent.startDate.hour,
                             aEvent.startDate.minute, aEvent.startDate.second);
    eventString += dateTime.toLocaleString ();
  }
  */

  return eventString;
}
 
function initEventFilter(event)
{
  if (event.originalTarget != window.document)
    return;

  window.removeEventListener("load", initEventFilter, true);
  window.addEventListener("unload", removeEventFilter, true);

  gEventFilter = Components.classes[EVENT_DETECTOR_CID].createInstance(); 
  gEventFilter = gEventFilter.QueryInterface(Components.interfaces.csIEventFilter);
  
  var observerService = Components.classes["@mozilla.org/observer-service;1"]
                                  .getService(Components.interfaces.nsIObserverService);
  observerService.addObserver(EventDetectionObserver, "MsgMsgDisplayed", false);

  getMessageBrowser().addProgressListener(messageWindowProgressListener);
}

function removeEventFilter(event)
{
  if (event.originalTarget != window.document)
    return;

  var observerService = Components.classes["@mozilla.org/observer-service;1"]
                                  .getService(Components.interfaces.nsIObserverService);
  observerService.removeObserver(EventDetectionObserver, "MsgMsgDisplayed");
}

function addDetectedEvent(aEvent)
{
  var bar = document.getElementById("eventsFilterBar");
  bar.setAttribute("collapsed", "true");

  var onNewItem = function(item, calendar, originalItem) {
      mainWindow.doTransaction('add', item, calendar, null, null);
  }

  // If we are in separate window access methods from main window
  var win = window.opener ? window.opener : window;
  win.openEventDialog(aEvent.QueryInterface(Components.interfaces.calIEvent), 
                                  win.getSelectedCalendar(), "new", onNewItem);
}

function ignoreEventFilter()
{
  var message = GetLoadedMessage();
  var msgHdr = messenger.messageServiceFromURI(message).messageURIToMsgHdr(message);
  var folder = msgHdr.folder;
  var imapFolder = true;

  try {
    folder.QueryInterface(Components.interfaces.nsIMsgImapMailFolder);
  } catch (ex) { 
    imapFolder = false;
  }

  // Ignore future events on this mesage
  msgHdr.setUint32Property("X-Synovel-IgnoreEvents", 1);
    
  // Hide the bar now.
  var bar = document.getElementById("eventsFilterBar");
  bar.setAttribute("collapsed", "true");
}

function ignoreEventsSet()
{
  var message = GetLoadedMessage();
  var msgHdr = messenger.messageServiceFromURI(message).messageURIToMsgHdr(message);

  return (msgHdr.getUint32Property("X-Synovel-IgnoreEvents") == 1)
}

var messageWindowProgressListener = new Object();

messageWindowProgressListener.QueryInterface =
function (aIID)
{
  /*
  if (!aIID.equals(nsIWebProgressListener) && !aIID.equals(nsISupports))
    throw Components.results.NS_ERROR_NO_INTERFACE;
  */

  return this;
}

messageWindowProgressListener.onLocationChange =
function (webProgress, request, location)
{
  var bar = document.getElementById("eventsFilterBar");
  bar.setAttribute("collapsed", "true");
}

messageWindowProgressListener.onProgressChange =
function (webProgress, request, curSelfProgress, maxSelfProgress,
          curTotalProgress, maxTotalProgress) { }

messageWindowProgressListener.onSecurityChange =
function (webProgress, request, state) { }

messageWindowProgressListener.onStateChange =
function (webProgress, request, stateFlags, status) { }

messageWindowProgressListener.onStatusChange =
function (webProgress, request, status, message) { }

